﻿//////////////////////////////////////////////
// MatrixWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkMathsWrap
{
	class DLL_ASTRAEUS_EXPORT MatrixWrapper final
	{
		public :

			// Environment update
			static void updateEnvironment (nkScripts::Environment* env) ;

			// Callbacks
			// Construction / destruction
			static void* constructor (const nkScripts::DataStack& stack) ;
			static void destructor (void* toDestroy) ;
			static nkScripts::OutputValue newMat2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue newMat3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue newMat4 (const nkScripts::DataStack& stack) ;
			// Getters
			static nkScripts::OutputValue getM (void* data) ;
			static nkScripts::OutputValue getRow0 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getRow1 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getRow2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getRow3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getCol0 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getCol1 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getCol2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getCol3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue get (const nkScripts::DataStack& stack) ;
			// Setters
			static void setM (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue set (const nkScripts::DataStack& stack) ;
			// Alterations
			static nkScripts::OutputValue getInverseMat2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getInverseMat3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getInverseMat4 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getTranspose (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue inverseMat2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue inverseMat3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue inverseMat4 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue transpose (const nkScripts::DataStack& stack) ;
			// Transformations
			static nkScripts::OutputValue getPositionComponent (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getOrientationComponent (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getScaleComponent (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getDecomposed (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setToViewMatrixDirection (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setToPerspectiveMatrix (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setToOrthographicMatrix (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setPositionComponent (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setOrientationComponent (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setScaleComponent (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setToTransformation (const nkScripts::DataStack& stack) ;
			// Utilities
			static nkScripts::OutputValue getDeterminantMat2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getDeterminantMat3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getDeterminantMat4 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getTraceMat2 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getTraceMat3 (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getTraceMat4 (const nkScripts::DataStack& stack) ;
			// Conversions
			static nkScripts::OutputValue toString (const nkScripts::DataStack& stack) ;
			// Operators
			static nkScripts::OutputValue add (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue sub (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue mul (const nkScripts::DataStack& stack) ;
			// Logical
			static nkScripts::OutputValue eq (const nkScripts::DataStack& stack) ;
	} ;
}